/*=============================================================================}
{ This demo shows how to scroll to specified position of document using        }
{ special invisible labels - "checkpoints"                                     }
{ Key methods and properties:                                                  }
{ - AddNamedCheckpoint;                                                        }
{ - GetCheckpointByNo, FindCheckpointByName;                                   }
{ - GetCheckpointY, GetCheckpointYEx;                                          }
{ - ScrollTo                                                                   }
{ - Options (rvoShowCheckpoints)                                               }
{=============================================================================*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  for (int i=1; i<4; i++)
  {
    RichView1->AddNamedCheckpoint(AnsiString("C")+IntToStr(i));
    RichView1->AddFmt("Chapter %d", ARRAYOFCONST((i)), 1,1);
    for (int j=0; j<30; j++)
    {
	  RichView1->AddNLWTag("Bla - bla - bla - bla - bla - bla - bla - bla"
		"- bla - bla - bla - bla - bla - bla - bla - bla",0,0,0);
	}
  }
  RichView1->AddNamedCheckpoint("END");
  RichView1->Format();
  /*
	Comments:

	Checkpoints are not items. They are special additional information,
	associated with any item.
	(in older, freeware versions, checkpoints were items)
	But checkpoint can be added like any other item using Add*** methods:
	AddNamedCheckpoint, AddCheckpoint, AddNamedCheckpointEx, and some other.

	AddNamedCheckpoint("") == AddCheckpoint

	Checkpoint added with any of these methods will be associated with next
	added item (if no items added after it, checkpoints becomes special
	end-of-text checkpoint which is not associated with any item)

	Do not try to add checkpoints one after another without items between them
	(it's impossible, and causes the exception)
  */
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
  // toggles checkpoints visibility
  if (CheckBox1->Checked)
	RichView1->Options << rvoShowCheckpoints;
  else
	RichView1->Options >> rvoShowCheckpoints;
  RichView1->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // GetCheckpointByNo(checkpoint index) - returns value of type TCheckpointData,
  // identifying checkpoint
  TCheckpointData CheckpointData = RichView1->GetCheckpointByNo(0);
  // GetCheckpointYEx returns Y coordinate of checkpoint
  int Y = RichView1->GetCheckpointYEx(CheckpointData);
  // ScrollTo - scrolls to specified Y coordinate
  RichView1->ScrollTo(Y);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  // The same actions, more compact
  RichView1->ScrollTo(RichView1->GetCheckpointYEx(RichView1->GetCheckpointByNo(1)));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  // Even more compact
  RichView1->ScrollTo(RichView1->GetCheckpointY(2));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
  // We can use checkpoint name to find it
  RichView1->ScrollTo(
	 RichView1->GetCheckpointYEx(
	   RichView1->FindCheckpointByName("END")
								)
					  );
}
//---------------------------------------------------------------------------